
(function(){
  const root = document.documentElement;
  const saved = localStorage.getItem('theme');
  if(saved==='dark') document.body.classList.add('dark');
  document.getElementById('toggleTheme')?.addEventListener('click', e=>{
    document.body.classList.toggle('dark');
    localStorage.setItem('theme', document.body.classList.contains('dark')?'dark':'light');
  });

  const form = document.querySelector('form');
  const pwrap = document.getElementById('pwrap');
  const pbar = document.getElementById('pbar');
  const toast = document.getElementById('toast');
  if(form){
    form.addEventListener('submit', ()=>{
      if(pwrap){ pwrap.classList.add('show'); pbar.style.width='10%'; }
      let w=10;
      const id = setInterval(()=>{ w=Math.min(95,w+Math.random()*12); pbar.style.width=w+'%'; }, 300);
      form.addEventListener('ajaxdone', ()=>{ clearInterval(id); pbar.style.width='100%'; setTimeout(()=>pwrap.classList.remove('show'), 800); });
    });
  }
  // if server rendered a message, just show toast
  if(toast && toast.dataset.msg){ toast.querySelector('.msg').textContent = toast.dataset.msg; toast.classList.add('show'); setTimeout(()=>toast.classList.remove('show'), 4000); }
})();
